<?php

use \UtillzCore\Inc\Src\Request\Request;

defined('ABSPATH') || exit;

global $ulz_listing;

$request = Request::instance();
$entry_type = Ucore()->get('ulz_entry_type');
$current_user_id = get_current_user_id();
$request_user_id = Ucore()->get('ulz_request_user_id', $ulz_listing->id);
$userdata = get_userdata( $request_user_id );

?>

<div class="ulz--content">
    <table>
        <tbody>
            <tr>
                <td><?php esc_html_e( 'Type', 'utillz-core' ); ?></td>
                <td><?php echo esc_html( Ucore()->get_entry_type( Ucore()->get( 'ulz_entry_type' ) ) ); ?></td>
            </tr>
            <tr>
                <td><?php esc_html_e( 'Created', 'utillz-core' ); ?></td>
                <td><?php echo get_the_date( get_option('date_format') ); ?></td>
            </tr>
            <?php if( $request->get('type') == 'sent' ): ?>
                <?php $owner = get_userdata( $ulz_listing->post->post_author ); ?>
                <?php if( isset( $owner->display_name ) ): ?>
                    <tr>
                        <td><?php esc_html_e( 'Sent to', 'utillz-core' ); ?></td>
                        <td><?php echo esc_html( $owner->display_name ); ?></td>
                    </tr>
                <?php endif; ?>
            <?php else: ?>
                <?php if( isset( $userdata->display_name ) ): ?>
                    <tr>
                        <td><?php esc_html_e( 'User', 'utillz-core' ); ?></td>
                        <td><?php echo esc_html( $userdata->display_name ); ?></td>
                    </tr>
                <?php endif; ?>
            <?php endif; ?>
            <?php if( $entry_type == 'purchase' ): ?>
                <?php $pricing = Ucore()->json_decode( Ucore()->get('ulz_pricing') ); ?>
                <?php if( $pricing ): ?>
                    <?php if( isset( $pricing->total ) ): ?>
                        <tr>
                            <td><?php esc_html_e( 'Total', 'utillz-core' ); ?></td>
                            <td><?php echo Ucore()->format_price( $pricing->total ); ?></td>
                        </tr>
                    <?php endif; ?>
                    <?php if( isset( $pricing->processing ) ): ?>
                        <tr>
                            <td><?php esc_html_e( 'Total payed', 'utillz-core' ); ?></td>
                            <td><?php echo Ucore()->format_price( $pricing->processing ); ?></td>
                        </tr>
                    <?php endif; ?>
                <?php endif; ?>
            <?php endif; ?>
        </tbody>
    </table>
</div>
